/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.modlauncher;

import cpw.mods.modlauncher.ArgumentHandler;
import cpw.mods.modlauncher.LaunchPluginHandler;
import cpw.mods.modlauncher.LogMarkers;
import cpw.mods.modlauncher.ModuleLayerHandler;
import cpw.mods.modlauncher.TransformingClassLoader;
import cpw.mods.modlauncher.TransformingClassLoaderBuilder;
import cpw.mods.modlauncher.api.ILaunchHandlerService;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.NamedPath;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

class LaunchServiceHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<String, ILaunchHandlerService> handlers = new HashMap<String, ILaunchHandlerService>();

    public LaunchServiceHandler(ModuleLayerHandler layerHandler) {
        ServiceLoader<ILaunchHandlerService> services = ServiceLoader.load(layerHandler.getLayer(IModuleLayerManager.Layer.BOOT).orElseThrow(), ILaunchHandlerService.class);
        Iterator<ILaunchHandlerService> loader = services.iterator();
        while (loader.hasNext()) {
            try {
                ILaunchHandlerService srvc = loader.next();
                this.handlers.put(srvc.name(), srvc);
            }
            catch (ServiceConfigurationError sce) {
                LOGGER.fatal("Encountered serious error loading transformation service, expect problems", (Throwable)sce);
            }
        }
        LOGGER.debug(LogMarkers.MODLAUNCHER, "Found launch services [{}]", new Supplier[]{() -> String.join((CharSequence)",", this.handlers.keySet())});
    }

    public Optional<ILaunchHandlerService> findLaunchHandler(String name) {
        return Optional.ofNullable(this.handlers.getOrDefault(name, null));
    }

    private void launch(String target, String[] arguments, ModuleLayer gameLayer, TransformingClassLoader classLoader, LaunchPluginHandler launchPluginHandler) {
        ILaunchHandlerService launchServiceHandlerDecorator = this.handlers.get(target);
        NamedPath[] paths = launchServiceHandlerDecorator.getPaths();
        launchPluginHandler.announceLaunch(classLoader, paths);
        LOGGER.info(LogMarkers.MODLAUNCHER, "Launching target '{}' with arguments {}", (Object)target, LaunchServiceHandler.hideAccessToken(arguments));
        try {
            launchServiceHandlerDecorator.launchService(arguments, gameLayer).run();
        }
        catch (Throwable e) {
            LaunchServiceHandler.sneak(e);
        }
    }

    static List<String> hideAccessToken(String[] arguments) {
        ArrayList<String> output = new ArrayList<String>();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0 && Objects.equals(arguments[i - 1], "--accessToken")) {
                output.add("**********");
                continue;
            }
            output.add(arguments[i]);
        }
        return output;
    }

    public void launch(ArgumentHandler argumentHandler, ModuleLayer gameLayer, TransformingClassLoader classLoader, LaunchPluginHandler launchPluginHandler) {
        String launchTarget = argumentHandler.getLaunchTarget();
        String[] args = argumentHandler.buildArgumentList();
        this.launch(launchTarget, args, gameLayer, classLoader, launchPluginHandler);
    }

    TransformingClassLoaderBuilder identifyTransformationTargets(ArgumentHandler argumentHandler) {
        TransformingClassLoaderBuilder builder = new TransformingClassLoaderBuilder();
        for (Path path : argumentHandler.getSpecialJars()) {
            builder.addTransformationPath(path);
        }
        return builder;
    }

    void validateLaunchTarget(ArgumentHandler argumentHandler) {
        String target = argumentHandler.getLaunchTarget();
        if (!this.handlers.containsKey(target)) {
            LOGGER.error(LogMarkers.MODLAUNCHER, "Cannot find launch target {}, unable to launch", (Object)target);
            throw new IllegalArgumentException("Cannot find launch target " + target + " Known: " + String.join((CharSequence)",", this.handlers.keySet()));
        }
    }

    private static <E extends Throwable, R> R sneak(Throwable exception) throws E {
        throw exception;
    }
}

